// 19/11/2018
//
// Genus 1

load "FiberProductsData.m";


jCM:={0,1728,2^4*3^3*5^3,2^3*3^3*11^3,-3^3*5^3,3^3*5^3*17^3,2^6*5^3,-2^(15)*3*5^3,-2^(15),-2^(15)*3^3,-2^(18)*3^3*5^3,-2^(15)*3^3*5^3*11^3,-2^(18)*3^3*5^3*23^3*29^3};



function aux_XXXXX(k,u,label,g)
	Zx<x>:=PolynomialRing(Integers());
	v:=Setseq({1,2} diff {u})[1];
	j := Groups[k[v]]`jmap;
	case label:
   		when "2Cn": 
   			f:=j-1728;
   		when "4X3": 
   			f:=1728-j;
   		when "8X4": 
   			f:=2*(1728-j);
   		when "8X5": 
   			f:=2*(j-1728);
	end case; 
	ff:=(Zx!Coefficients(Numerator(f)))*(Zx!Coefficients(Denominator(f)));
   	L:=Factorization(ff);
   	pol:=&*[h[1]^(h[2] mod 2) : h in L]; 
   	pol:=Sign(LeadingCoefficient(ff))*pol;	
   	R<x,y>:=PolynomialRing(Rationals(),2);
	C:=ProjectiveClosure(Curve(AffineSpace(R),y^2-Evaluate(pol,x)));
	bound:=10^3;
	Pts := PointSearch(C,bound);
	Pts:=[p : p in Pts | Multiplicity(p) eq 1];
	if #Pts ne 0 then
		Pt:=Pts[1];
		E,mp1 := EllipticCurve(C,Pt);
		EE,mm := MinimalModel(E);
		mm:=mm^-1;
		MW:=AbelianInvariants(MordellWeilGroup(EE));
		T,mp2 := TorsionSubgroup(EE);
		rE:=Rank(EE);
		PtsC := { };
		for p in T do
			PtsC := PtsC join RationalPoints(mm(mp2(p)) @@ mp1);
		end for;
   		js:= {Evaluate(j,P[1]/P[3]) : P in PtsC | Evaluate(Denominator(j),P[1]) ne 0 and P[3] ne 0};
		if rE ne 0 then 
			printf "[oo] %o - %o - MW = %o --> %o ==> %o\n", k,CremonaReference(E),MW, js,	js diff jCM; 
	  	  else
			printf "     %o - %o - MW = %o --> %o ==> %o\n", k,CremonaReference(E),MW, js,	js diff jCM;		  
		end if;
		return true,(js diff jCM), CremonaReference(E), MW,rE, js;
	  else
	    H:=HyperellipticCurve(pol);
	    S:=[q : q in BadPrimes(H) | not IsLocallySolvable(H,q)];
		if #S ne 0 then
			 printf "     %o - Locally %o ==> {}\n", k,S;		  
			 return true,{},"NonElliptic",0,0,0;
           else
           	 printf " HHHH %o \n",k;
           	 return false,{},0,0,0,0;		  
		end if;
	end if;
end function;




function XXXXX(k,g)
	boo:=#({"2Cn","4X3","8X4","8X5"} meet Seqset(k)) ne 0;;
//	assert  boo;
	if not boo then 
		printf "YYYY %o\n",k; 
		return false,0,0,0,0,0;
	end if;
	
	i2:=Index(k,"2Cn");
	i3:=Index(k,"4X3");
	i4:=Index(k,"8X4");
	i5:=Index(k,"8X5");
	
	
	R<x,y>:=PolynomialRing(Rationals(),2);
	
	if i2 ne 0 then 
		boo,jsnoCM,labelE,MW,rE,js:=aux_XXXXX(k,i2,"2Cn",g);	
	end if;
   
	if i3 ne 0 then
   		boo,jsnoCM,labelE,MW,rE,js:=aux_XXXXX(k,i3,"4X3",g);	
	end if;

   
	if i4 ne 0 then
      	boo,jsnoCM,labelE,MW,rE,js:=aux_XXXXX(k,i4,"8X4",g);	
	end if;

	if i5 ne 0 then
      	boo,jsnoCM,labelE,MW,rE,js:=aux_XXXXX(k,i5,"8X5",g);	   
	end if;
	return boo,jsnoCM,labelE,MW,rE,js;
end function;

function EEEEE(k,C,Pt)
	E,mp1 := EllipticCurve(C,Pt);
	MW:=AbelianInvariants(MordellWeilGroup(E));
	T,mp2 := TorsionSubgroup(E);
	rE:=Rank(E);
	PtsC := { };
	for p in T do
		PtsC := PtsC join RationalPoints(mp2(p) @@ mp1);
	end for;
	j1 := Groups[k[1]]`jmap;
	j2 := Groups[k[2]]`jmap;
	J1 := {Evaluate(j1,P[1]/P[3]) : P in PtsC | Evaluate(Denominator(j1),P[1]) ne 0 and P[3] ne 0};
	J2 := {Evaluate(j2,P[2]/P[3]) : P in PtsC | Evaluate(Denominator(j2),P[2]) ne 0 and P[3] ne 0};
	assert J1 eq J2;
	js:=J1;
	if rE ne 0 then 
		printf "[oo] %o - %o - MW = %o --> %o ==> %o\n",k,CremonaReference(E),MW, js,	js diff jCM;
	  else
		printf "     %o - %o - MW = %o --> %o ==> %o\n",k,CremonaReference(E),MW, js,	js diff jCM;		  
	end if;
	return true,(js diff jCM), CremonaReference(E), MW,rE, js;
end function;


//Genus1:= AssociativeArray();
//Genus1PosRank:= AssociativeArray();
//Genun1Rank0:= AssociativeArray();
//Genus1NonElliptic:= AssociativeArray();
//Genus1Unknown:= AssociativeArray();

Genus1PosRank:= [];
Genus1Rank0_with:= [];
Genus1Rank0_without:= [];
Genus1NonElliptic:= [];
Genus1Unknown:= [];

print "=== Genus 1 (Data) === ";
g:=1;
bound:=10^3;
for k in CurvesByGenus[g] do
	C:=FiberProducts[k]`curve;
 	Pts := PointSearch(C,bound);
	Pts:=[p : p in Pts | Multiplicity(p) eq 1];
	if #Pts ne 0 then 
		Pt:=Pts[1]; 
		E,mp1 := EllipticCurve(C,Pt);
		MW:=AbelianInvariants(MordellWeilGroup(E));
		T,mp2 := TorsionSubgroup(E);
		rE:=Rank(E);
		PtsC := { };
		for p in T do
			PtsC := PtsC join RationalPoints(mp2(p) @@ mp1);
		end for;
		j1 := Groups[k[1]]`jmap;
		j2 := Groups[k[2]]`jmap;
		J1 := {Evaluate(j1,P[1]/P[3]) : P in PtsC | Evaluate(Denominator(j1),P[1]) ne 0 and P[3] ne 0};
		J2 := {Evaluate(j2,P[2]/P[3]) : P in PtsC | Evaluate(Denominator(j2),P[2]) ne 0 and P[3] ne 0};
		assert J1 eq J2;
		js:=J1;
		if rE ne 0 then 
			printf "[oo] %o - %o - MW = %o --> %o ==> %o\n",k,CremonaReference(E),MW, js,	js diff jCM;
	  	  else
			printf "     %o - %o - MW = %o --> %o ==> %o\n",k,CremonaReference(E),MW, js,	js diff jCM;		  
		end if;
		boo:=true;
		jsnoCM:=(js diff jCM);
		labelE:=CremonaReference(E);
		//boo,jsnoCM,labelE,MW,rE,js:=EEEEE(C,Pt);
	  else
	    boo,jsnoCM,labelE,MW,rE,js:=XXXXX(k,g);
	end if;
	if boo then
		if labelE eq "NonElliptic" then 
			//Append(~Genus1["NonElliptic"],k);
			Append(~Genus1NonElliptic,k);
		  else
		    if rE ne 0 then
		    	//Append(~Genus1["PosRank"],k);
		    	Append(~Genus1PosRank,k);
		      else
		      	//Append(~Genus1["Rank0"],k);
		      	if #jsnoCM eq 0 then
		      		Append(~Genus1Rank0_without,k);
		      	  else
		      	  	Append(~Genus1Rank0_with,k);
		      	end if;
		    end if;
		end if;
	  else
		printf "TODO: By hand %o\n",k;
		//Append(~Genus1["Unknown"],k);
		Append(~Genus1Unknown,k);
	end if;
end for;


procedure LATEX(file,name_list,list,text)

	fprintf file, "\n//// %o\n %o := [\n",text,name_list;
	for i in [1..#list] do
		k := list[i];
		if i ne #list then
			fprintf file, "[\"%o\",\"%o\"],\n", k[1],k[2];
		end if;
		if i eq #list then
			fprintf file, "[\"%o\",\"%o\"]\n", k[1],k[2];
		end if;		
	end for;
	fprintf file, "];\n";
end procedure;

LATEX("output_genus1.txt","Genus1PosRank",Genus1PosRank,"Genus 1 with positive rank:");
LATEX("output_genus1.txt","Genus1Rank0_with",Genus1Rank0_with,"Genus 1 with rank 0 and non-CM j-invariants:");
LATEX("output_genus1.txt","Genus1Rank0_without",Genus1Rank0_without,"Genus 1 with rank 0 and without non-CM j-invariants:");
LATEX("output_genus1.txt","Genus1NonElliptic",Genus1NonElliptic,"Genus 1 non-elliptic:");
LATEX("output_genus1.txt","Genus1Unknown",Genus1Unknown,"Genus 1: TODO by hand:");


/*
fprintf "output_genus1.txt", "//Genus 1 with positive rank:\n Genus1PosRank:=%o;\n\n",Genus1PosRank;
fprintf "output_genus1.txt", "//Genus 1 with rank 0 and non-CM j-invariants:\n Genus1Rank0_with:=%o;\n\n",Genus1Rank0_with;
fprintf "output_genus1.txt", "//Genus 1 with rank 0 and without non-CM j-invariants:\n Genus1Rank0_without:=%o;\n\n",Genus1Rank0_without;
fprintf "output_genus1.txt", "//Genus 1 non-elliptic:\n Genus1NonElliptic:=%o;\n\n",Genus1NonElliptic;
fprintf "output_genus1.txt", "//Genus 1: TODO by hand:\n Genus1Unknown:=%o;\n",Genus1Unknown;
*/

function jInvariants_Genus1Rank0_with(k)
	assert k in Genus1Rank0_with;
	
	C:=FiberProducts[k]`curve;
 	Pts := PointSearch(C,bound);
	Pts:=[p : p in Pts | Multiplicity(p) eq 1];
	Pt:=Pts[1]; 
	E,mp1 := EllipticCurve(C,Pt);
	MW:=AbelianInvariants(MordellWeilGroup(E));
	T,mp2 := TorsionSubgroup(E);
	rE:=Rank(E);
	assert rE eq 0;
	PtsC := { };
	for p in T do
		PtsC := PtsC join RationalPoints(mp2(p) @@ mp1);
	end for;
	j1 := Groups[k[1]]`jmap;
	j2 := Groups[k[2]]`jmap;
	J1 := {Evaluate(j1,P[1]/P[3]) : P in PtsC | Evaluate(Denominator(j1),P[1]) ne 0 and P[3] ne 0};
	J2 := {Evaluate(j2,P[2]/P[3]) : P in PtsC | Evaluate(Denominator(j2),P[2]) ne 0 and P[3] ne 0};
	assert J1 eq J2;
	js:=J1;
	jsnoCM:=(js diff jCM);
	labelE:=CremonaReference(E);
	return labelE,MW,jsnoCM;
	
end function;



printf "\n%o\n\n", "Genus 1 Rank 0 with points:";
for k in Genus1Rank0_with do
	labelE,MW,jsnoCM:=jInvariants_Genus1Rank0_with(k);
	printf "%o - %o - %o ==> %o\n",k,labelE,MW,jsnoCM;
	for j in jsnoCM do
		printf "j=%o --> %o\n",j,CremonaReference(MinimalQuadraticTwist(j));
	end for;
end for;





